<?php $__env->startSection('title', 'Customer Quotes'); ?>

<?php $__env->startSection('content_header'); ?>
    <h1>Customer Quotes</h1>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_css'); ?>
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .select2-container--default .select2-dropdown .select2-search__field:focus, .select2-container--default .select2-search--inline .select2-search__field:focus {
            outline: 0;
            border: none;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-container .select2-selection--single {
            height: calc(2.25rem + 2px);
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: auto;
            position: absolute;
            top: 50%;
            right: 1px;
            width: 20px;
            transform: translateY(-50%);
        }

        table th, table td, .column-no-whitespace {
            white-space: nowrap;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="card card-secondary">
        <div class="card-header bg-white">
            <h3 class="card-title"><a href="javascript:void(0);" class="text-blue">Add search condition</a></h3>
            <i class="fa fa-angle-down float-right"></i>
        </div>
        <div class="card-body" style="display: none;">

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="listingTable">
                    <thead>
                    <tr>
                        <th>First Name</th>
                        <th>Surname</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Postcode</th>
                        <th>Product Name</th>
                        <th>Product Price</th>
                        <th>Product Qty</th>
                        <th>Created At</th>
                        <th>Token</th>
                        <th>Product Configuration</th>
                        <th>Token Expired</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php if(count($quotes ?? []) > 0): ?>
                        <?php $__currentLoopData = $quotes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quote): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($quote->first_name); ?></td>
                                <td><?php echo e($quote->surname); ?></td>
                                <td><?php echo e($quote->phone); ?></td>
                                <td><?php echo e($quote->email); ?></td>
                                <td><?php echo e($quote->city); ?></td>
                                <td><?php echo e($quote->state); ?></td>
                                <td><?php echo e($quote->postcode); ?></td>
                                <td><?php echo e($quote->product_name); ?></td>
                                <td><?php echo e($quote->product_price); ?></td>
                                <td><?php echo e($quote->product_qty); ?></td>
                                <td><?php echo e($quote->created_at); ?></td>
                                <td><?php echo e($quote->token); ?></td>
                                <td><?php echo e($quote->product_configuration); ?></td>
                                <td><?php echo e($quote->token_expires_at); ?></td>
                                <td>
                                    <a href="<?php echo e(route('quote.view', $quote->id)); ?>" class="btn btn-primary" title="Edit">
                                        <i class="fas fa-fw fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(route('quote.delete', $quote->id)); ?>" class="btn btn-danger" title="Remove">
                                        <i class="fas fa-fw fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="11" align="center">No quote found</td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    
    
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_js'); ?>
    <script>
        $(document).ready(function () {
            $('#listingTable').DataTable({
				"order": [[ 10, "desc" ]],
			});
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/teammjay-golfworld/htdocs/golfworld.teammjay.com/resources/views/quote/list.blade.php ENDPATH**/ ?>