<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Quote Accepted</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <style>
    /* Basic mobile responsiveness */
    @media only screen and (max-width: 600px) {
      .container { width: 100% !important; padding: 16px !important; }
      .content { padding: 18px !important; }
      .logo { max-width: 160px !important; }
      .btn { width: 100% !important; box-sizing: border-box; text-align: center; display: inline-block; }
    }
  </style>
</head>
<body style="margin:0; padding:0; background-color:#ffd800; font-family:Helvetica, Arial, sans-serif; -webkit-font-smoothing:antialiased;">
  <!-- Outer wrapper -->
  <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td align="center" style="padding:32px 16px;">
        <!-- Centered card -->
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="600" class="container" style="width:600px; max-width:100%; background: linear-gradient(180deg, rgba(255,216,0,0.98) 0%, rgba(255,230,90,0.98) 100%); border-radius:8px; box-shadow:0 6px 18px rgba(0,0,0,0.12); overflow:hidden;">
          <!-- Header with logo -->
          <tr>
            <td align="left" style="padding:24px 28px; background-color:transparent;">
              <img src="https://www.golfworld.com.au/assets/themes/gallant-20221222/img/web_logo.png?1757530753"
                   alt="Golf World / Golf Mart" border="0"
                   style="display:block; max-width:220px; height:auto;" class="logo">
            </td>
          </tr>

          <!-- Body / content -->
          <tr>
            <td style="padding:24px 28px 18px 28px;">
              <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%" style="background:#ffffff; border-radius:6px;">
                <tr>
                  <td class="content" style="padding:28px; color:#111111; line-height:1.5;">
                    <h1 style="margin:0 0 12px 0; font-size:22px; color:#111; font-weight:700;">New Quote Accepted</h1>

                    <p style="margin:0 0 14px 0; font-size:15px;">
                      Hello <?php echo e($quote->name); ?>,
                    </p>

                    <p style="margin:0 0 18px 0; font-size:15px;">
                      Great news — your quote has been <strong>accepted</strong>! You can now purchase the product using the link below.
                    </p>

                    <!-- Styled anchor that looks like a button (not a <button> tag) -->
                    <p style="margin:0 0 12px 0;">
                      <a href="<?php echo e($link); ?>" class="btn" role="button" style="
                          display:inline-block;
                          padding:12px 20px;
                          background-color:#111111;
                          color:#ffffff;
                          text-decoration:none;
                          font-weight:600;
                          border-radius:6px;
                          box-shadow:0 4px 10px rgba(0,0,0,0.12);
                          ">
                        View & Purchase
                      </a>
                    </p>

                    <p style="margin:12px 0 0 0; font-size:13px; color:#555;">
                      If the button doesn't work, copy and paste this link into your browser:
                    </p>
                    <p style="margin:6px 0 0 0; font-size:13px; word-break:break-all;">
                      <a href="<?php echo e($link); ?>" style="color:#111; text-decoration:underline;"><?php echo e($link); ?></a>
                    </p>

                    <hr style="border:none; border-top:1px solid #f0f0f0; margin:20px 0;">

                    <p style="margin:0; font-size:13px; color:#777;">
                      If you have questions or need help, reply to this email or contact our support team.
                    </p>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td align="center" style="padding:12px 28px 24px 28px; color:#111; font-size:12px;">
              <span style="color:#111; font-weight:600;">Golf World / Golf Mart</span>
              <div style="margin-top:6px; color:#222; opacity:0.85;">All we slice is the price®</div>
            </td>
          </tr>
        </table>
        <!-- end centered card -->
      </td>
    </tr>
  </table>
</body>
</html>
<?php /**PATH /home/teammjay-golfworld/htdocs/golfworld.teammjay.com/resources/views/emails/quotes/request.blade.php ENDPATH**/ ?>