<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <title>Customer Quote Request</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <style>
    @media only screen and (max-width: 600px) {
      .container { width: 100% !important; padding: 16px !important; }
      .content { padding: 18px !important; }
      .logo { max-width: 160px !important; }
    }
  </style>
</head>
<body style="margin:0; padding:0; background-color:#ffd800; font-family:Helvetica, Arial, sans-serif; -webkit-font-smoothing:antialiased;">
  <!-- Outer wrapper -->
  <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
    <tr>
      <td align="center" style="padding:32px 16px;">
        <!-- Card -->
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="600" class="container" style="width:600px; max-width:100%; background:#ffffff; border-radius:8px; box-shadow:0 6px 18px rgba(0,0,0,0.12); overflow:hidden;">
          <!-- Logo -->
          <tr>
            <td align="left" style="padding:24px 28px; background-color:#ffd800;">
              <img src="https://www.golfworld.com.au/assets/themes/gallant-20221222/img/web_logo.png?1757530753"
                   alt="Golf World / Golf Mart" border="0"
                   style="display:block; max-width:220px; height:auto;" class="logo">
            </td>
          </tr>

          <!-- Body -->
          <tr>
            <td style="padding:28px;">
              <h1 style="margin:0 0 16px 0; font-size:22px; color:#111; font-weight:700;">New Quote Request</h1>
              <p style="margin:0 0 16px 0; font-size:15px; color:#333;">
                Hello Admin,<br><br>
                A customer has submitted a new quote request. Please see the details below:
              </p>

              <!-- Customer Details -->
              <h3 style="margin:24px 0 10px 0; font-size:17px; color:#111;">Customer Details</h3>
              <table role="presentation" cellpadding="6" cellspacing="0" border="0" width="100%" style="border:1px solid #eee; border-radius:6px; font-size:14px; color:#333;">
                <tr><td><strong>Name:</strong></td><td>{{ $quote->first_name }} {{ $quote->surname }}</td></tr>
                <tr><td><strong>Phone:</strong></td><td>{{ $quote->phone }}</td></tr>
                <tr><td><strong>Email:</strong></td><td>{{ $quote->email }}</td></tr>
                <tr><td><strong>City:</strong></td><td>{{ $quote->city }}</td></tr>
                <tr><td><strong>State:</strong></td><td>{{ $quote->state }}</td></tr>
                <tr><td><strong>Zipcode:</strong></td><td>{{ $quote->postcode }}</td></tr>
                @if($quote->message)
                <tr><td><strong>Message:</strong></td><td>{{ $quote->message }}</td></tr>
                @endif
                
              </table>

              <!-- Product Details -->
              <h3 style="margin:28px 0 10px 0; font-size:17px; color:#111;">Product Details</h3>
              <table role="presentation" cellpadding="6" cellspacing="0" border="0" width="100%" style="border:1px solid #eee; border-radius:6px; font-size:14px; color:#333;">
                <tr><td><strong>Name:</strong></td><td>{{ $quote->product_name }}</td></tr>
                <tr><td><strong>Price:</strong></td><td>{{ $quote->product_price }}</td></tr>
                <tr><td><strong>URL:</strong></td><td><a href="{{ $quote->product_url }}" style="color:#111; text-decoration:underline;">{{ $quote->product_url }}</a></td></tr>
                  @if($quote->product_configuration)
                @php
                  $config = json_decode($quote->product_configuration, true) ?? [];
                  $chunks = array_chunk($config, 2);
                @endphp
                <tr>
                  <td><strong>Product Configuration:</strong></td>
                  <td>
                    <table role="presentation" cellpadding="6" cellspacing="0" border="0" width="100%" style="font-size:14px; color:#333;">
                      @foreach($chunks as $pair)
                        <tr>
                          @foreach($pair as $item)
                            <td style="vertical-align:top; width:50%; border:0; padding:4px 8px;">
                              <strong>{{ $item['name'] ?? $item['name'] ?? '' }}:</strong>
                              {{ $item['label'] ?? '' }}
                            </td>
                          @endforeach
                          @if(count($pair) < 2)
                            <td style="vertical-align:top; width:50%; border:0; padding:4px 8px;"></td>
                          @endif
                        </tr>
                      @endforeach
                    </table>
                  </td>
                </tr>
                @endif
                <tr><td><strong>Link User Requested:</strong></td><td><a href="{{ $link }}" style="color:#111; text-decoration:underline;">{{ $link }}</a></td></tr>
              </table>

              <p style="margin:24px 0 0 0; font-size:13px; color:#777;">
                Please follow up with the customer at your earliest convenience.
              </p>
            </td>
          </tr>

          <!-- Footer -->
          <tr>
            <td align="center" style="padding:18px; background:#ffd800; font-size:12px; color:#111;">
              <span style="font-weight:600;">Golf World / Golf Mart</span><br>
              <span style="opacity:0.9;">All we slice is the price®</span>
            </td>
          </tr>
        </table>
        <!-- end card -->
      </td>
    </tr>
  </table>
</body>
</html>
