@extends('adminlte::page')

@section('title', 'Customer Quotes')

@section('content_header')
    <h1>Customer Quotes</h1>
@stop

@section('adminlte_css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .select2-container--default .select2-dropdown .select2-search__field:focus, .select2-container--default .select2-search--inline .select2-search__field:focus {
            outline: 0;
            border: none;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-container .select2-selection--single {
            height: calc(2.25rem + 2px);
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: auto;
            position: absolute;
            top: 50%;
            right: 1px;
            width: 20px;
            transform: translateY(-50%);
        }

        table th, table td, .column-no-whitespace {
            white-space: nowrap;
        }
    </style>
@stop

@section('content')
    <div class="card card-secondary">
        <div class="card-header bg-white">
            <h3 class="card-title"><a href="javascript:void(0);" class="text-blue">Add search condition</a></h3>
            <i class="fa fa-angle-down float-right"></i>
        </div>
        <div class="card-body" style="display: none;">

        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover" id="listingTable">
                    <thead>
                    <tr>
                        <th>First Name</th>
                        <th>Surname</th>
                        <th>Phone</th>
                        <th>Email</th>
                        <th>City</th>
                        <th>State</th>
                        <th>Postcode</th>
                        <th>Product Name</th>
                        <th>Product Price</th>
                        <th>Product Qty</th>
                        <th>Created At</th>
                        <th>Token</th>
                        <th>Product Configuration</th>
                        <th>Token Expired</th>
                        <th>Action</th>
                    </tr>
                    </thead>
                    <tbody>
                    @if(count($quotes ?? []) > 0)
                        @foreach($quotes as $quote)
                            <tr>
                                <td>{{ $quote->first_name }}</td>
                                <td>{{ $quote->surname }}</td>
                                <td>{{ $quote->phone }}</td>
                                <td>{{ $quote->email }}</td>
                                <td>{{ $quote->city }}</td>
                                <td>{{ $quote->state }}</td>
                                <td>{{ $quote->postcode }}</td>
                                <td>{{ $quote->product_name }}</td>
                                <td>{{ $quote->product_price }}</td>
                                <td>{{ $quote->product_qty }}</td>
                                <td>{{ $quote->created_at }}</td>
                                <td>{{ $quote->token }}</td>
                                <td>{{ $quote->product_configuration }}</td>
                                <td>{{ $quote->token_expires_at }}</td>
                                <td>
                                    <a href="{{ route('quote.view', $quote->id) }}" class="btn btn-primary" title="Edit">
                                        <i class="fas fa-fw fa-eye"></i>
                                    </a>
                                    <a href="{{ route('quote.delete', $quote->id) }}" class="btn btn-danger" title="Remove">
                                        <i class="fas fa-fw fa-trash"></i>
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    @else
                        <tr>
                            <td colspan="11" align="center">No quote found</td>
                        </tr>
                    @endif
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

@section('adminlte_js')
    <script>
        $(document).ready(function () {
            $('#listingTable').DataTable({
				"order": [[ 10, "desc" ]],
			});
        });
    </script>
@stop
