<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('customer_quote_requests', function (Blueprint $table) {
            $table->string('product_id')->nullable()->after('product_url');
            $table->string('product_name')->after('product_id');
            $table->string('product_sku')->after('product_name');
            $table->string('product_price')->after('product_sku');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('customer_quote_requests', function (Blueprint $table) {
            $table->dropColumn('product_id');
            $table->dropColumn('product_name');
            $table->dropColumn('product_sku');
            $table->dropColumn('product_price');
        });
    }
};
