<?php

use App\Http\Controllers\ProfileController;
// use App\Http\Controllers\Api\QuoteRequestController;
use App\Http\Controllers\CustomerQuotesController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('welcome');
});

// Route::post('/quote-request', [QuoteRequestController::class, 'insert']);

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::controller(CustomerQuotesController::class)->group(function () {
        Route::get('/customer_quote', 'index')->name('quote.index');
        Route::get('/customer_quote/view/{id}', 'view')->name('quote.view');
        Route::get('/customer_quote/delete/{id}', 'destroy')->name('quote.delete');
    });
});

require __DIR__.'/auth.php';
