<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\QuoteRequestController;

// ---------- CORS preflight (OPTIONS) ----------
Route::options('/{any}', function (Request $request) {
    // Keep this aligned with the controller’s ALLOWED_ORIGIN and USE_CREDENTIALS
    $headers = [
        'Access-Control-Allow-Origin'  => 'https://www.golfworld.com.au',
        'Vary'                         => 'Origin',
        'Access-Control-Allow-Methods' => 'GET, POST, PUT, PATCH, DELETE, OPTIONS',
        'Access-Control-Allow-Headers' => 'Content-Type, Authorization, X-Requested-With, Accept, Origin',
        'Access-Control-Max-Age'       => '600',
    ];

    // If you truly need cookies/Authorization across sites, also include:
    // $headers['Access-Control-Allow-Credentials'] = 'true';

    return response('', 204)->withHeaders($headers);
})->where('any', '.*');

// ---------- API routes ----------
Route::post('/quote-request', [QuoteRequestController::class, 'insert']);
Route::get('/verify-token/{token}', [QuoteRequestController::class, 'validateToken']);
