@extends('adminlte::page')

@section('title', 'Customer Quote')

@section('content_header')
    <h1>Customer Quote - #{{ $quote->id }}</h1>
@stop

@section('adminlte_css')
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .select2-container--default .select2-dropdown .select2-search__field:focus, .select2-container--default .select2-search--inline .select2-search__field:focus {
            outline: 0;
            border: none;
        }

        .select2-container {
            width: 100% !important;
        }

        .select2-container .select2-selection--single {
            height: calc(2.25rem + 2px);
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            height: auto;
            position: absolute;
            top: 50%;
            right: 1px;
            width: 20px;
            transform: translateY(-50%);
        }

        table th, table td, .column-no-whitespace {
            white-space: nowrap;
        }
    </style>
@stop

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="carrier_name">First Name :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->first_name }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="surname">Surname :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->surname }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="phone">Phone :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->phone }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="email">Email :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->email }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="city">City :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->city }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="state">State :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->state }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="postcode">Postcode :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->postcode }}
                        </div>
                    </div>

                </div>
                <div class="col-md-6">
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_id">Product ID :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_id }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_name">Product Name :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_name }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_sku">Product SKU :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_sku }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_price">Product Price :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_price }}
                        </div>
                    </div>
					<div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_price">Product Quantity :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_qty }}
                        </div>
                    </div>
                    <div class="row mt-3 g-3 align-items-center">
                        <div class="col-md-3">
                            <label for="product_url">Product URL :-</label>
                        </div>
                        <div class="col-md-9">
                            {{ $quote->product_url }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@stop

@section('css')
    {{-- Add here extra stylesheets --}}
    {{-- <link rel="stylesheet" href="/css/admin_custom.css"> --}}
@stop

